#include <stdio.h>
#include <fcntl.h>
#include "adsp-spiadc.h"

extern void setup_spi(int descriptor);
extern void Band_pass_filter(int *filter_data, int *output_data);

int  input_descriptor;
int  output_descriptor;
long temp;
int  input_data[8];
int  filter_data[8];
char output_data[8];

int main(void)
{

    printf("AM Radio Example program\n\r");
	// open the two IO files
	input_descriptor = open("/dev/spi", O_RDWR);
	output_descriptor= open("/dev/ppi0", O_WR);

    setup_spi(input_descriptor);
	// this loop runs forever until we kill the process
	while(1)
	{
	   // SPI requires that you write before you read
	   write(input_descriptor, input_data, 8);
       read(input_descriptor, input_data, 8);

       // (long) changes our 12 bit input data to 32 bit
       // data.  Here we square the data and scale it back
       // to 16 bits before storing it in the filter array

	   temp = (long) input_data[0] * (long) input_data[0];
	   temp = temp / 65536;
	   filter_data[0] = temp;
	   temp = (long) input_data[1] * (long) input_data[1];
	   temp = temp / 65536;
	   filter_data[1] = temp;
	   temp = (long) input_data[2] * (long) input_data[2];
	   temp = temp / 65536;
	   filter_data[2] = temp;
	   temp = (long) input_data[3] * (long) input_data[3];
	   temp = temp / 65536;
	   filter_data[3] = temp;
	   temp = (long) input_data[4] * (long) input_data[4];
	   temp = temp / 65536;
	   filter_data[4] = temp;
	   temp = (long) input_data[5] * (long) input_data[5];
	   temp = temp / 65536;
	   filter_data[5] = temp;
	   temp = (long) input_data[6] * (long) input_data[6];
	   temp = temp / 65536;
	   filter_data[6] = temp;
	   temp = (long) input_data[7] * (long) input_data[7];
	   temp = temp / 65536;

	   filter_data[7] = temp;
	   // we send the data to the filtering function here
	   Band_pass_filter(filter_data, output_data);
	   // output the data here
	   write(output_descriptor, output_data, 8);
	}

    return(0);
}
